<?php

/**
 * Created by PhpStorm.
 * User: cneah
 * Date: 1/10/2016
 * Time: 2:57 PM
 */


function gplsrfqtk_after_calculate_totals($cart)
{

    $in_role = true;
    $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

    $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
    if ($roles === '') {
        $enable_roles = 'no';
    }

    if ($enable_roles === "purchase" && is_user_logged_in()) {

        $in_role = false;

        $user = wp_get_current_user();
        $user_roles = $user->roles;

        $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

        $option_value_list = explode(',', $eligible_roles);

        foreach ($user_roles as $cat_id) {

            if (in_array(trim($cat_id), $option_value_list)) {
                $in_role = true;
            }
        }

        $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

    }


    $quote_request_limit = strval(get_option('settings_gpls_woo_rfq_plus_normal_checkout_limit', ''));
    $cart_total = WC()->cart->get_total('number');

    $limit = false;

    //add_action('woocommerce_check_cart_items',  'gplsrfqtk_quote_request_removed_message', 100);


    if ($in_role == true && $quote_request_limit > 0 && $quote_request_limit > strval($cart_total)
        && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'yes') {

        $limit = true;

        if (!is_admin()) {
            add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_remove_quote_request', 1100, 1);
        }
    }


}

function gplsrfqtk_limit_to_rfq_only_after_calculate_totals($cart)
{

    $has_rfq = false;
    $has_purchase = false;
    $specific_gateway = 'gpls-rfq';

    $checkout_option=get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout');
    $is_quote_if_no_shipping = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping', 'no');

    if ( $checkout_option == 'rfq' && $is_quote_if_no_shipping == 'yes') {

      //  $specific_gateway = 'gpls-rfq';
       // apply_filters( 'woocommerce_cart_needs_shipping', $needs_shipping );

        WC()->initialize_session();

        $methods = WC()->cart->calculate_shipping();

        if (empty($methods)) {
            add_filter('woocommerce_cart_needs_shipping', function($needs_shipping){return false;});
            $has_rfq = true;
            $payment_method = 'gpls-rfq';
            WC()->session->set('chosen_payment_method', $payment_method);
        } else {
            WC()->session->set('chosen_payment_method', null);
        }

    }

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        WC()->session->set('chosen_payment_method', null);
    }

    foreach ($items as $item_key => $values) {

        $_product = wc_get_product($values['product_id']);

       // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
      //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        $rfq_enable = apply_filters('gpls_rfq_enable_at_checkout', $rfq_enable, $_product->get_id(), $item_key, $values);

        if ($rfq_enable == 'yes') {
            $has_rfq = true;
        } else {
            $has_purchase = true;
        }

    }


    $has_rfq = apply_filters('gpls_has_quote_items', $has_rfq, $settings_gpls_woo_rfq_limit_to_rfq_only,$checkout_option,$is_quote_if_no_shipping,$cart);
    $has_purchase = apply_filters('gpls_has_quote_items', $has_purchase,$settings_gpls_woo_rfq_limit_to_rfq_only,$checkout_option,$is_quote_if_no_shipping,$cart);

    $settings_gpls_woo_rfq_5j = get_option('settings_gpls_woo_rfq_5j', 'no');

    if ($settings_gpls_woo_rfq_5j == "no") {

        if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {
            if (!is_admin()) {
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_quote_request', 2000, 1);

            }

        }

        if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq != true) {
            if (!is_admin()) {
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_limit_to_rfq_only_purchase', 2000, 1);
            }
        }

    }

    if ($settings_gpls_woo_rfq_5j == "yes") {

        if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true && $has_purchase == false) {
            if (!is_admin()) {
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_quote_request', 2000, 1);
            }

        }
        if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true && $has_purchase == true) {
            if (!is_admin()) {
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_limit_to_rfq_only_purchase', 2000, 1);
            }

        }


        if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq != true && $has_purchase == true) {
            if (!is_admin()) {
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_limit_to_rfq_only_purchase', 2000, 1);
            }
        }
    }

}


function gplsrfqtk_quote_request_removed_message()
{
    $quote_request_limit_message = get_option('settings_gpls_woo_rfq_plus_normal_checkout_limit_message', '');
    $quote_request_limit_message = __($quote_request_limit_message, 'rfqtk');


    $quote_request_limit_message5c1 = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_message_quote', '');
    $quote_request_limit_message5c1 = __($quote_request_limit_message5c1, 'rfqtk');

    $quote_request_limit_message5c2 = get_option('settings_gpls_woo_rfq_limit_to_rfq_only_message_purchase', '');
    $quote_request_limit_message5c2 = __($quote_request_limit_message5c2, 'rfqtk');

    $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

    if ($settings_gpls_woo_rfq_limit_to_rfq_only == "no") {

        if ($quote_request_limit_message != '') {
            if (WC()->cart != null && !WC()->cart->is_empty()) {
                wc_add_notice($quote_request_limit_message, 'notice');
            }
        }

    } else {

        $items = WC()->cart->get_cart();

        $has_rfq = false;

        foreach ($items as $item => $values) {

            $_product = wc_get_product($values['product_id']);

           // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
           // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

            $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


            if ($rfq_enable == 'yes') {
                $has_rfq = true;
                break;
            }
        }

        if ($quote_request_limit_message5c1 != '' && $has_rfq == true) {
            if (WC()->cart != null && !WC()->cart->is_empty()) {
                wc_add_notice($quote_request_limit_message5c1, 'notice');
            }
        }
        if ($quote_request_limit_message5c2 != '' && $has_rfq == false) {
            if (WC()->cart != null && !WC()->cart->is_empty()) {
                wc_add_notice($quote_request_limit_message5c2, 'notice');
            }
        }


    }


}


function gplsrfqtk_remove_quote_request($available_gateways)
{
    if (is_admin()) {
        return $available_gateways;
    }

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id == 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
            return $available_gateways;
        }
    }

    return $available_gateways;

}

function gplsrfqtk_only_quote_request($available_gateways)
{
    if (is_admin()) {
        return $available_gateways;
    }

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        WC()->session->set('chosen_payment_method', null);
    }

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id != 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
        } else {
            WC()->session->set('chosen_payment_method', 'gpls-rfq');
        }
    }

    return $available_gateways;
}


//note duplicate definition
if (!function_exists('gplsrfqtk_only_purchase')) {
    function gplsrfqtk_only_purchase($available_gateways)
    {

        if (is_admin()) {
            return $available_gateways;
        }

        if (isset($_GET['pay_for_order'])) {
            unset($available_gateways['gpls-rfq']);
            return $available_gateways;
        }

        foreach ($available_gateways as $gateway_id => $gateway) {

            if ($gateway_id == 'gpls-rfq') {
                unset($available_gateways[$gateway_id]);
                return $available_gateways;
            }
        }

        return $available_gateways;
    }
}


function gplsrfqtk_limit_to_rfq_only_purchase($available_gateways)
{

    if (is_admin()) {
        return $available_gateways;
    }

    if (get_option('settings_gplsrfqtk_limit_to_rfq_only_purchase_option', "purchase_only") == "purchase_or_quote") {
        return $available_gateways;
    }

    if (isset($_GET['pay_for_order'])) {
        unset($available_gateways['gpls-rfq']);
        return $available_gateways;
    }

    foreach ($available_gateways as $gateway_id => $gateway) {

        if ($gateway_id == 'gpls-rfq') {
            unset($available_gateways[$gateway_id]);
            return $available_gateways;
        }
    }

    return $available_gateways;
}


class WC_Gateway_RFQ_Plus
{
    /**
     * Constructor
     */
    public function __construct()
    {


        $checkout_option = "";
        $purchase_or_quote = false;

        if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
            $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
        }


        $in_role = true;

        $enable_roles = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
        if ($roles === '') {
            $enable_roles = 'no';
        }

        if ($enable_roles != "no" && !is_user_logged_in()) {
            $in_role = false;
        }

        if ($enable_roles != "no" && is_user_logged_in()) {
            $in_role = false;

            $user = wp_get_current_user();
            $user_roles = $user->roles;


            $eligible_roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');

            $option_value_list = explode(',', $eligible_roles);

            foreach ($user_roles as $cat_id) {

                if (in_array(trim($cat_id), $option_value_list)) {
                    $in_role = true;

                }
            }

            $in_role = apply_filters('rfqtk_is_in_role', $in_role, $user);

        }


        if ($checkout_option == 'rfq' && $in_role == true
            && get_option('settings_gpls_woo_rfq_plus_normal_checkout', 'no') == 'yes'
            && (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'yes'
                || get_option('settings_gpls_woo_rfq_show_prices_everywhere', 'no') == 'yes')
        ) {
            $purchase_or_quote = true;
        }

        if (function_exists('wp_get_current_user')) {

            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $purchase_or_quote = false;

            }
        }

        $limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', 'no');

        $limit_by_role = get_option('settings_gpls_woo_rfq_plus_role_based_visible', 'no');

        $roles = get_option('settings_gpls_woo_rfq_plus_visible_price_roles', 'no');
        if ($roles === '') {
            $limit_by_role = 'no';
        }


        if ($purchase_or_quote == true || $limit_to_rfq_only == "yes") {
            add_action('woocommerce_check_cart_items', 'gplsrfqtk_quote_request_removed_message', 100);
        }


        if ($purchase_or_quote == true && $limit_to_rfq_only == "no") {

            if (($limit_by_role == "others_purchase_only" || $limit_by_role == "purchase" || $limit_by_role == "no") && $in_role == true) {
                if (!is_admin()) {
                    remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                    add_action('woocommerce_after_calculate_totals', 'gplsrfqtk_after_calculate_totals', 1000, 1);
                }

                return;

            }
            if (($limit_by_role == "others_purchase_only" || $limit_by_role == "no") && $in_role == false) {
                if (!is_admin()) {
                    remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                    add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_purchase', 2000, 1);
                }

                return;
            }
        }

        if ($purchase_or_quote == true && $limit_to_rfq_only == "yes") {
            if (!is_admin()) {
                remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                add_action('woocommerce_after_calculate_totals', 'gplsrfqtk_limit_to_rfq_only_after_calculate_totals', 1000, 1);

            }

            return;
        }

        if ($purchase_or_quote == false && $limit_by_role == "others_purchase_only") {
            if (!is_admin()) {
                remove_filter('woocommerce_available_payment_gateways', 'gpls_rfq_remove_other_payment_gateways', 1000, 1);
                add_filter('woocommerce_available_payment_gateways', 'gplsrfqtk_only_purchase', 2000, 1);

            }

            return;

        }

    }
}

?>