<?php
namespace Aws\Ecs;

use Aws\AwsClient;

/**
 * This client is used to interact with **Amazon ECS**.
 *
 * @method \Aws\Result createCapacityProvider(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createCapacityProviderAsync(array $args = [])
 * @method \Aws\Result createCluster(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createClusterAsync(array $args = [])
 * @method \Aws\Result createService(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createServiceAsync(array $args = [])
 * @method \Aws\Result createTaskSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createTaskSetAsync(array $args = [])
 * @method \Aws\Result deleteAccountSetting(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAccountSettingAsync(array $args = [])
 * @method \Aws\Result deleteAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAttributesAsync(array $args = [])
 * @method \Aws\Result deleteCapacityProvider(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteCapacityProviderAsync(array $args = [])
 * @method \Aws\Result deleteCluster(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteClusterAsync(array $args = [])
 * @method \Aws\Result deleteService(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteServiceAsync(array $args = [])
 * @method \Aws\Result deleteTaskSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteTaskSetAsync(array $args = [])
 * @method \Aws\Result deregisterContainerInstance(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deregisterContainerInstanceAsync(array $args = [])
 * @method \Aws\Result deregisterTaskDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deregisterTaskDefinitionAsync(array $args = [])
 * @method \Aws\Result describeCapacityProviders(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeCapacityProvidersAsync(array $args = [])
 * @method \Aws\Result describeClusters(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeClustersAsync(array $args = [])
 * @method \Aws\Result describeContainerInstances(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeContainerInstancesAsync(array $args = [])
 * @method \Aws\Result describeServices(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeServicesAsync(array $args = [])
 * @method \Aws\Result describeTaskDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeTaskDefinitionAsync(array $args = [])
 * @method \Aws\Result describeTaskSets(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeTaskSetsAsync(array $args = [])
 * @method \Aws\Result describeTasks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeTasksAsync(array $args = [])
 * @method \Aws\Result discoverPollEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise discoverPollEndpointAsync(array $args = [])
 * @method \Aws\Result executeCommand(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise executeCommandAsync(array $args = [])
 * @method \Aws\Result listAccountSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listAccountSettingsAsync(array $args = [])
 * @method \Aws\Result listAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listAttributesAsync(array $args = [])
 * @method \Aws\Result listClusters(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listClustersAsync(array $args = [])
 * @method \Aws\Result listContainerInstances(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listContainerInstancesAsync(array $args = [])
 * @method \Aws\Result listServices(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listServicesAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result listTaskDefinitionFamilies(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTaskDefinitionFamiliesAsync(array $args = [])
 * @method \Aws\Result listTaskDefinitions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTaskDefinitionsAsync(array $args = [])
 * @method \Aws\Result listTasks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTasksAsync(array $args = [])
 * @method \Aws\Result putAccountSetting(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putAccountSettingAsync(array $args = [])
 * @method \Aws\Result putAccountSettingDefault(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putAccountSettingDefaultAsync(array $args = [])
 * @method \Aws\Result putAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putAttributesAsync(array $args = [])
 * @method \Aws\Result putClusterCapacityProviders(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putClusterCapacityProvidersAsync(array $args = [])
 * @method \Aws\Result registerContainerInstance(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise registerContainerInstanceAsync(array $args = [])
 * @method \Aws\Result registerTaskDefinition(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise registerTaskDefinitionAsync(array $args = [])
 * @method \Aws\Result runTask(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise runTaskAsync(array $args = [])
 * @method \Aws\Result startTask(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startTaskAsync(array $args = [])
 * @method \Aws\Result stopTask(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise stopTaskAsync(array $args = [])
 * @method \Aws\Result submitAttachmentStateChanges(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise submitAttachmentStateChangesAsync(array $args = [])
 * @method \Aws\Result submitContainerStateChange(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise submitContainerStateChangeAsync(array $args = [])
 * @method \Aws\Result submitTaskStateChange(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise submitTaskStateChangeAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateCapacityProvider(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateCapacityProviderAsync(array $args = [])
 * @method \Aws\Result updateCluster(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateClusterAsync(array $args = [])
 * @method \Aws\Result updateClusterSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateClusterSettingsAsync(array $args = [])
 * @method \Aws\Result updateContainerAgent(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateContainerAgentAsync(array $args = [])
 * @method \Aws\Result updateContainerInstancesState(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateContainerInstancesStateAsync(array $args = [])
 * @method \Aws\Result updateService(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateServiceAsync(array $args = [])
 * @method \Aws\Result updateServicePrimaryTaskSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateServicePrimaryTaskSetAsync(array $args = [])
 * @method \Aws\Result updateTaskSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateTaskSetAsync(array $args = [])
 */
class EcsClient extends AwsClient {}
