<?php
namespace Aws\LicenseManager;

use Aws\AwsClient;

/**
 * This client is used to interact with the **AWS License Manager** service.
 * @method \Aws\Result acceptGrant(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise acceptGrantAsync(array $args = [])
 * @method \Aws\Result checkInLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkInLicenseAsync(array $args = [])
 * @method \Aws\Result checkoutBorrowLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkoutBorrowLicenseAsync(array $args = [])
 * @method \Aws\Result checkoutLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkoutLicenseAsync(array $args = [])
 * @method \Aws\Result createGrant(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createGrantAsync(array $args = [])
 * @method \Aws\Result createGrantVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createGrantVersionAsync(array $args = [])
 * @method \Aws\Result createLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createLicenseAsync(array $args = [])
 * @method \Aws\Result createLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result createLicenseConversionTaskForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createLicenseConversionTaskForResourceAsync(array $args = [])
 * @method \Aws\Result createLicenseManagerReportGenerator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \Aws\Result createLicenseVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createLicenseVersionAsync(array $args = [])
 * @method \Aws\Result createToken(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createTokenAsync(array $args = [])
 * @method \Aws\Result deleteGrant(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGrantAsync(array $args = [])
 * @method \Aws\Result deleteLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteLicenseAsync(array $args = [])
 * @method \Aws\Result deleteLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result deleteLicenseManagerReportGenerator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \Aws\Result deleteToken(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteTokenAsync(array $args = [])
 * @method \Aws\Result extendLicenseConsumption(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise extendLicenseConsumptionAsync(array $args = [])
 * @method \Aws\Result getAccessToken(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAccessTokenAsync(array $args = [])
 * @method \Aws\Result getGrant(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getGrantAsync(array $args = [])
 * @method \Aws\Result getLicense(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getLicenseAsync(array $args = [])
 * @method \Aws\Result getLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result getLicenseConversionTask(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getLicenseConversionTaskAsync(array $args = [])
 * @method \Aws\Result getLicenseManagerReportGenerator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \Aws\Result getLicenseUsage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getLicenseUsageAsync(array $args = [])
 * @method \Aws\Result getServiceSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getServiceSettingsAsync(array $args = [])
 * @method \Aws\Result listAssociationsForLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listAssociationsForLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result listDistributedGrants(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listDistributedGrantsAsync(array $args = [])
 * @method \Aws\Result listFailuresForLicenseConfigurationOperations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listFailuresForLicenseConfigurationOperationsAsync(array $args = [])
 * @method \Aws\Result listLicenseConfigurations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicenseConfigurationsAsync(array $args = [])
 * @method \Aws\Result listLicenseConversionTasks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicenseConversionTasksAsync(array $args = [])
 * @method \Aws\Result listLicenseManagerReportGenerators(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicenseManagerReportGeneratorsAsync(array $args = [])
 * @method \Aws\Result listLicenseSpecificationsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicenseSpecificationsForResourceAsync(array $args = [])
 * @method \Aws\Result listLicenseVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicenseVersionsAsync(array $args = [])
 * @method \Aws\Result listLicenses(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listLicensesAsync(array $args = [])
 * @method \Aws\Result listReceivedGrants(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listReceivedGrantsAsync(array $args = [])
 * @method \Aws\Result listReceivedLicenses(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listReceivedLicensesAsync(array $args = [])
 * @method \Aws\Result listResourceInventory(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listResourceInventoryAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result listTokens(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTokensAsync(array $args = [])
 * @method \Aws\Result listUsageForLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listUsageForLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result rejectGrant(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise rejectGrantAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateLicenseConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateLicenseConfigurationAsync(array $args = [])
 * @method \Aws\Result updateLicenseManagerReportGenerator(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateLicenseManagerReportGeneratorAsync(array $args = [])
 * @method \Aws\Result updateLicenseSpecificationsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateLicenseSpecificationsForResourceAsync(array $args = [])
 * @method \Aws\Result updateServiceSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateServiceSettingsAsync(array $args = [])
 */
class LicenseManagerClient extends AwsClient {}
